#include <stdio.h>
#include <winsock.h>
#include "Pagalba.h"

#define MAXHOSTNAME 20
#define PORTAS 5462

int main(int argc, char *argv[]){
/****************************************************************/
/*	Winsock inicializacija                                      */
/****************************************************************/
    WORD wVersionRequested;
	WSADATA wsaData;
	wVersionRequested = MAKEWORD( 2, 2 );
	WSAStartup( wVersionRequested, &wsaData );

/****************************************************************/
/*	Susizinosime savo hosto adresa		 						*/
/****************************************************************/
	char myname[MAXHOSTNAME+1];
	gethostname(myname, MAXHOSTNAME);
	struct hostent *hp= gethostbyname(myname);
	if (hp == NULL){
        printf("Ivyko klaida randant host'o adresa: %i\n", WSAGetLastError());
		return -1;
	}

/****************************************************************/
/*	Sukuriame soketa					 						*/
/****************************************************************/
	SOCKET s= socket(AF_INET, SOCK_STREAM, 0);
	if (s < 0){
		printf("Ivyko klaida kuriant soketa: %i\n", WSAGetLastError());
		return -1;
	}

/****************************************************************/
/*	Susiejame soketa su portu			 						*/
/****************************************************************/
	struct sockaddr_in sa;
	memset(&sa, 0, sizeof(struct sockaddr_in));	//uzpildo atminti 0
	sa.sin_family= hp->h_addrtype;
	sa.sin_port= htons(PORTAS);
	if (bind(s, (struct sockaddr *)&sa, sizeof(struct sockaddr_in)) < 0){
		closesocket(s);
		printf("Ivyko klaida siejant soketa su portu: %i\n", WSAGetLastError());
		printf("\t(porto numeris - %i)\n", PORTAS);
		return -1;
	}

/****************************************************************/
/*	Laukiame prisijungimo				 						*/
/****************************************************************/
	listen(s, 3);	//3 - maximalus laukianciu klientuskaicius
	printf("Laukiu prisijungimu!\n");

    SOCKET t;
	if ((t= accept(s,NULL,NULL)) < 0){
	    printf("Ivyko klaida laukiant prisijungimo: %i\n", WSAGetLastError());
		return -1;
	}

/****************************************************************/
/*	Apdorojame kliento uzklausas		 						*/
/****************************************************************/
    char tempStr[MAX_DYDIS];
    PriimtiStr(t, 7, tempStr);   //laukiame sutarto ilgio pasisveikinimo
    printf("Gavau pranesima: %s\n", tempStr);

    int sk1= PriimtiSk(t);  //laukiame pirmo parametro
    printf("Gavau skaiciu: %d\n", sk1);
    int sk2= PriimtiSk(t);  //laukiame antro parametro
    printf("Gavau skaiciu: %d\n", sk2);
    int rez= sk1+sk2;
    SiustiSk(t, rez);   //siunciame rezultata
    printf("Issiunciau skaiciu: %d\n", rez);


/****************************************************************/
/*	Uzdarome soketus                                            */
/****************************************************************/
    closesocket(t);
    closesocket(s);
    WSACleanup();

    return 0;
}
